package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.orgVirtual.OrgVirtualNodeDTO;
import com.xforceplus.jpa.listener.OrgVirtualNodeListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * @author    duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_virtual_node")
@EntityListeners({OrgVirtualNodeListener.class})
public class OrgVirtualNode extends OrgVirtualNodeDTO implements Serializable {


    private OrgVirtual orgVirtual;

    @Override
    @Id
    @Column(name = "org_virtual_node_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getOrgVirtualNodeId() {
        return orgVirtualNodeId;
    }

    @Override
    @Basic
    @Column(name = "org_virtual_id")
    public Long getOrgVirtualId() {
        return orgVirtualId;
    }


    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }


    @Override
    @Basic
    @Column(name = "parent_id")
    public Long getParentId() {
        return parentId;
    }

    @Override
    @Basic
    @Column(name = "node_type_id")
    public Long getNodeTypeId() {
        return nodeTypeId;
    }


    @Override
    @Basic
    @Column(name = "parent_ids")
    public String getParentIds() {
        return parentIds;
    }


    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }


    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_virtual_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgVirtual getOrgVirtual() {
        return orgVirtual;
    }
}
