package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.OrgVirtualNodeUserRelListener;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * @author  duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_virtual_node_user_rel")
@EntityListeners({OrgVirtualNodeUserRelListener.class})
public class OrgVirtualNodeUserRel implements Serializable, IOperator {

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "虚拟组织树ID")
    private Long orgVirtualNodeId;

    @ApiModelProperty(value = "人员id")
    private Long userId;

    @ApiModelProperty(value = "租户id")
    private Long tenantId;

    @ApiModelProperty(value = "是否控制下级 1是 0否")
    private Integer controlFlag;

    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    private String createrId;

    @ApiModelProperty(value = "创建人名称")
    private String createrName;

    @ApiModelProperty(value = "修改时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    private String updaterId;

    @ApiModelProperty(value = "修改人名称")
    private String updaterName;

    @ApiModelProperty(value = "节点下的管理员标识")
    private Integer  adminFlag;

    @ApiModelProperty(value = "用户的主组织标识")
    private Integer mainOrgFlag;

    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "org_virtual_node_id")
    public Long getOrgVirtualNodeId() {
        return orgVirtualNodeId;
    }

    @Basic
    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Basic
    @Column(name = "control_flag")
    public Integer getControlFlag() {
        return controlFlag;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }


    @Basic
    @Column(name = "admin_flag")
    public Integer getAdminFlag() {
        return adminFlag;
    }
    @Basic
    @Column(name = "main_org_flag")
    public Integer getMainOrgFlag() {
        return mainOrgFlag;
    }
}
