package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.conf.PrivacyAgreementProtocolDto;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;


/**
 * @author geewit
 * @since 2022-01-12
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_privacy_agreement_protocol")
public class PrivacyAgreementProtocol extends PrivacyAgreementProtocolDto implements Serializable {
    @JsonView(View.class)
    @JsonManagedReference
    private PrivacyAgreement privacyAgreement;

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @JsonView(View.class)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "agreement_id", nullable = false)
    @JsonView(View.class)
    public Long getAgreementId() {
        return agreementId;
    }

    @Override
    @Basic
    @Column(name = "title", nullable = false)
    @JsonView(View.class)
    public String getTitle() {
        return title;
    }

    @Override
    @Basic
    @Column(name = "url")
    @JsonView(View.class)
    public String getUrl() {
        return url;
    }

    @Override
    @Basic
    @Column(name = "ordinal", nullable = false)
    @JsonView(View.class)
    public Integer getOrdinal() {
        return ordinal;
    }



    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "agreement_id", referencedColumnName = "id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public PrivacyAgreement getPrivacyAgreement() {
        return privacyAgreement;
    }
}
