package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.jpa.listener.ResourceListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@SuppressWarnings("all")
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = Resource.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode("app")
                }
        )})
@DynamicInsert
@DynamicUpdate
@EntityListeners({ResourceListener.class})
@Entity
@Table(name = "sys_resource")
public class Resource extends ResourceDto<Resource> implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "Resource.graph";

    @JsonIgnore
    private App app;

    @JsonIgnore
    private List<ResourcesetResourceRel> resourcesetResourceRels;

    @JsonIgnore
    private List<ResourceApiRel> resourceApiRels;

    @Override
    @Id
    @Column(name = "resource_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getResourceId() {
        return resourceId;
    }

    @Override
    @Basic
    @Column(name = "app_id")
    public Long getAppId() {
        return (appId != null && appId > 0) ? appId : null;
    }

    @Override
    @Basic
    @Column(name = "resource_code", nullable = false)
    public String getResourceCode() {
        return resourceCode;
    }

    @Override
    @Basic
    @Column(name = "resource_name")
    public String getResourceName() {
        return resourceName;
    }

    @Override
    @Basic
    @Column(name = "resource_platform")
    public Integer getResourcePlatform() {
        return resourcePlatform;
    }

    @Override
    @Basic
    @Column(name = "resource_type")
    public Integer getResourceType() {
        return resourceType;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Basic
    @Column(name = "parent_id")
    public Long getParentId() {
        return parentId;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "is_service_package")
    public Boolean getIsServicePackage() {
        return isServicePackage;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "app_id", referencedColumnName = "app_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public App getApp() {
        return app;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "resource")
    public List<ResourcesetResourceRel> getResourcesetResourceRels() {
        return resourcesetResourceRels;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "resource")
    public List<ResourceApiRel> getResourceApiRels() {
        return resourceApiRels;
    }

    @Override
    @Transient
    public String getAppName() {
        return super.appName;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
