package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.jpa.listener.RoleListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.*;

import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({RoleListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role")
public class Role extends RoleDto implements Serializable {

    @JsonIgnore
    private List<RoleResourcesetRel> roleResourcesetRels;

    @JsonIgnore
    private List<RoleUserRel> roleUserRels;

    @JsonIgnore
    private List<OrgStruct> gradingOrgs;

    @JsonIgnore
    private List<OrgStruct> defaultOrgs;

    @JsonIgnore
    private Role fromRole;

    @Override
    @Id
    @Column(name = "role_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Basic
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "role_code", nullable = false)
    public String getCode() {
        return code;
    }

    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Basic
    @Column(name = "role_type", nullable = false)
    public Integer getType() {
        return type;
    }

    @Override
    @Temporal(TemporalType.DATE)
    @Column(name = "expired_date")
    @Basic
    public Date getExpiredDate() {
        return expiredDate;
    }

    @Override
    @Basic
    @Column(name = "role_name", nullable = false)
    public String getName() {
        return name;
    }

    @Override
    @Basic
    @Column(name = "role_desc", nullable = false)
    public String getRoleDesc() {
        return roleDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    @Basic
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    @Basic
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Basic
    @Column(name = "from_role_id")
    public Long getFromRoleId() {
        return fromRoleId;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleResourcesetRel> getRoleResourcesetRels() {
        return roleResourcesetRels;
    }


    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleUserRel> getRoleUserRels() {
        return roleUserRels;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "gradingRole")
    public List<OrgStruct> getGradingOrgs() {
        return gradingOrgs;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "defaultOrgRole")
    public List<OrgStruct> getDefaultOrgs() {
        return defaultOrgs;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "from_role_id", referencedColumnName = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getFromRole() {
        return fromRole;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
