package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_service_resourceset_rel")
public class ServiceResourcesetRel implements Serializable {
    private Long id;
    private Long servicePackageId;
    private Long resourcesetId;
    private String createUserName;

    @JsonIgnore
    private Resourceset resourceset;

    @JsonIgnore
    private ServicePackage servicePackage;


    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "service_package_id", nullable = false)
    public Long getServicePackageId() {
        return (servicePackageId != null && servicePackageId > 0) ? servicePackageId : null;
    }

    @Basic
    @Column(name = "resourceset_id", nullable = false)
    public Long getResourcesetId() {
        return (resourcesetId != null && resourcesetId > 0) ? resourcesetId : null;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resourceset_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Resourceset getResourceset() {
        return resourceset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServiceResourcesetRel that = (ServiceResourcesetRel) o;
        return servicePackageId.equals(that.servicePackageId) &&
                resourcesetId.equals(that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(servicePackageId, resourcesetId);
    }

    @Override
    public String toString() {
        return "ServiceResourcesetRel{" +
                "id=" + id +
                ", servicePackageId=" + servicePackageId +
                ", resourcesetId=" + resourcesetId +
                ", createUserName='" + createUserName + '\'' +
                '}';
    }
}
