package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.TenantRelationDto;
import com.xforceplus.jpa.listener.TenantRelationListener;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({TenantRelationListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_tenant_rel")
public class TenantRelation extends TenantRelationDto implements Serializable {

    @Override
    @Id
    @Basic
    @Column(name = "id", nullable = false)
    public Long getId() {
        return super.getId();
    }

    @Override
    @Basic
    @Column(name = "parent_tenant_id", nullable = false)
    public Long getParentTenantId() {
        return super.getParentTenantId();
    }

    @Override
    @Basic
    @Column(name = "child_tenant_id", nullable = false)
    public Long getChildTenantId() {
        return super.getChildTenantId();
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

}
