package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Account;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class AccountListener extends OperatorListener<Account> {
    @PrePersist
    public void prePersist(Account entity) {
        if (entity.getAccountId() == null) {
            long id = SnowflakeGenerator.id();
            entity.setAccountId(id);
        }
        if (StringUtils.isBlank(entity.getUsername())) {
            entity.setUsername(StringUtils.EMPTY);
        }
        if (StringUtils.isBlank(entity.getTelPhone())) {
            entity.setTelPhone(StringUtils.EMPTY);
        }
        if (StringUtils.isBlank(entity.getEmail())) {
            entity.setEmail(StringUtils.EMPTY);
        }
        if (entity.getBindAuthFlag() == null) {
            entity.setBindAuthFlag(false);
        }
        if (entity.getChangePasswordFlag() == null) {
            entity.setChangePasswordFlag(false);
        }
        if (entity.getDoubleAuthFlag() == null) {
            entity.setDoubleAuthFlag(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        Date now = Calendar.getInstance().getTime();
        if(null == entity.getUpdateTime()){
            entity.setUpdateTime(now);
        }
        if(null == entity.getCreateTime()){
            entity.setCreateTime(now);
        }
        this.cleanRelatedEntities(entity);
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Account entity) {
        if (StringUtils.isBlank(entity.getUsername())) {
            entity.setUsername(StringUtils.EMPTY);
        }
        if (StringUtils.isBlank(entity.getTelPhone())) {
            entity.setTelPhone(StringUtils.EMPTY);
        }
        if (StringUtils.isBlank(entity.getEmail())) {
            entity.setEmail(StringUtils.EMPTY);
        }
        this.cleanRelatedEntities(entity);
        super.beforeUpdate(entity);
    }

    private void cleanRelatedEntities(Account entity) {
        entity.setUsers(null);
    }
}