package com.xforceplus.jpa.listener;

import com.xforceplus.entity.CompanyServiceRel;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class CompanyServiceRelListener {
    @PrePersist
    public void prePersist(CompanyServiceRel entity) {
        Date now = Calendar.getInstance().getTime();
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(now);
        }
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyServiceRel entity) {
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(CompanyServiceRel entity) {
        entity.setServicePackage(null);
        entity.setCompany(null);
        entity.setTenant(null);
    }
}