package com.xforceplus.jpa.listener;

import com.xforceplus.entity.CompanyTenantRel;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class CompanyTenantRelListener {
    @PrePersist
    public void prePersist(CompanyTenantRel entity) {
        Date now = Calendar.getInstance().getTime();
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(now);
        }
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyTenantRel entity) {
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(CompanyTenantRel entity) {
        entity.setCompany(null);
        entity.setTenant(null);
        entity.setOrgs(null);
        entity.setRelatedCompany(null);
        entity.setRelatedTenant(null);
        entity.setRelatedOrgs(null);
    }
}