package com.xforceplus.jpa.listener;


import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;


/**
 * 公司租户关联关系操作记录 自动保存的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class CompanyTenantRelOperationListener {
    @PrePersist
    public void prePersist(CompanyTenantRelOperation entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreaterName(StringUtils.EMPTY);
            }
            entity.setCreaterTenantId(authorizedUser.getTenantId());
            entity.setCreaterTenantName(authorizedUser.getTenantName());
        }
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyTenantRelOperation entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setAuditorId(authorizedUser.getId());
            if (authorizedUser.getOperaterName() != null) {
                entity.setAuditorName(authorizedUser.getOperaterName());
            } else {
                entity.setAuditorName(StringUtils.EMPTY);
            }
            entity.setAuditorTenantId(authorizedUser.getTenantId());
            entity.setAuditorTenantName(authorizedUser.getTenantName());
            entity.setAuditTime(Calendar.getInstance().getTime());
        }
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(CompanyTenantRelOperation entity) {
        entity.setCompany(null);
    }
}