package com.xforceplus.jpa.listener;


import com.xforceplus.entity.OrgExtension;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 组织自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class OrgExtensionListener extends ExtensionListener<OrgExtension> {

    @PrePersist
    public void prePersist(OrgExtension entity) {
        super.preInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(OrgExtension entity) {
        super.preModify(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(OrgExtension entity) {
        entity.setOrg(null);
    }
}