package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Resourceset;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 资源码自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ResourcesetListener extends OperatorListener<Resourceset> {
    @PrePersist
    public void prePersist(Resourceset entity) {
        if (StringUtils.isBlank(entity.getResourcesetCode())) {
            entity.setResourcesetCode(UUID.randomUUID().toString());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Resourceset entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Resourceset entity) {
        entity.setResourcesetResourceRels(null);
        entity.setRoleResourcesetRels(null);
        entity.setServiceResourcesetRels(null);
    }
}