package com.xforceplus.jpa.listener;


import com.xforceplus.entity.ServicePackage;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 资源码自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ServicePackageListener extends OperatorListener<ServicePackage> {
    @PrePersist
    public void prePersist(ServicePackage entity) {
        if (StringUtils.isBlank(entity.getServicePackageCode())) {
            entity.setServicePackageCode(UUID.randomUUID().toString());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(ServicePackage entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(ServicePackage entity) {
        entity.setServiceResourcesetRels(null);
        entity.setCompanyServiceRels(null);
        entity.setApp(null);
    }
}