package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Tenant;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.geewit.utils.uuid.UUID;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 租户自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class TenantListener extends OperatorListener<Tenant> {
    @PrePersist
    public void prePersist(Tenant entity) {
        if (entity.getTenantId() == null) {
            long id = SnowflakeGenerator.id();
            entity.setTenantId(id);
        }
        if (entity.getTenantCode() == null) {
            entity.setTenantCode(UUID.randomUUID().toString());
        }
        if (entity.getTenantDesc() == null) {
            if (entity.getTenantName() != null) {
                entity.setTenantDesc(entity.getTenantName());
            }
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }

        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Tenant entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Tenant entity) {
        entity.setOrgs(null);
        entity.setUsers(null);
    }
}