package com.xforceplus.jpa.listener;


import com.xforceplus.entity.User;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class UserListener extends OperatorListener<User> {
    @PrePersist
    public void prePersist(User entity) {
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id();
            entity.setId(id);
        }
        if (entity.getUserPeriodTime() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2030, Calendar.DECEMBER, 31);
            entity.setUserPeriodTime(calendar.getTime());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getActiveStatus() == null) {
            entity.setActiveStatus(1);
        }
        if (entity.getExpiredDate() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2099, Calendar.DECEMBER, 31);
            entity.setExpiredDate(calendar.getTime());
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(User entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(User entity) {
        entity.setAccount(null);
        entity.setTenant(null);
        entity.setOrgs(null);
        entity.setRoleUserRels(null);
        entity.setOrgUserRels(null);
        entity.setUserApps(null);
        entity.setUserTags(null);
        entity.setOrgVirtualNodeUserRels(null);
    }
}