/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.jpa.listener.OrgExtensionListener;
import io.geewit.core.jackson.view.View;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@EntityListeners(value={OrgExtensionListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="org_extension")
public class OrgExtension
extends OrgExtensionDto
implements Serializable {
    private Long orgExtensionId;
    @JsonIgnore
    private OrgStruct org;

    @Id
    @Column(name="org_extension_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getOrgExtensionId() {
        return this.orgExtensionId;
    }

    @Column(name="org_struct_id", nullable=false)
    public Long getOrgStructId() {
        return super.getOrgStructId();
    }

    @Basic
    @Column(name="extension_key", nullable=false)
    public String getExtensionKey() {
        return super.getExtensionKey();
    }

    @Basic
    @Column(name="extension_value", nullable=false)
    public String getExtensionValue() {
        return super.getExtensionValue();
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time")
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="org_struct_id", referencedColumnName="org_struct_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return this.org;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantName() {
        if (this.tenantName == null && this.org != null) {
            this.tenantName = this.org.getTenantName();
        }
        return this.tenantName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantCode() {
        if (this.tenantCode == null && this.org != null) {
            this.tenantCode = this.org.getTenantCode();
        }
        return this.tenantCode;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getOrgName() {
        if (this.orgName == null && this.org != null) {
            this.orgName = this.org.getOrgName();
        }
        return this.orgName;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setOrgExtensionId(Long orgExtensionId) {
        this.orgExtensionId = orgExtensionId;
    }

    @JsonIgnore
    public void setOrg(OrgStruct org) {
        this.org = org;
    }
}

