/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.jpa.listener.OrgListener;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="Org.graph", attributeNodes={@NamedAttributeNode(value="company"), @NamedAttributeNode(value="tenant"), @NamedAttributeNode(value="gradingRole"), @NamedAttributeNode(value="defaultOrgRole")})})
@EntityListeners(value={OrgListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="sys_org_struct")
public class OrgStruct
extends OrgDto<OrgStruct>
implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "Org.graph";
    @JsonIgnore
    public boolean builtParentIds;
    @JsonView(value={OrgView.OrgInfo.class})
    @JsonManagedReference
    private Company company;
    @JsonView(value={OrgView.OrgInfo.class})
    @JsonManagedReference
    private Tenant tenant;
    @JsonView(value={OrgView.OrgInfo.class})
    private List<ServicePackage> packages;
    @JsonIgnore
    private List<OrgUserRel> orgUserRels;
    @JsonView(value={OrgView.OrgInfo.class})
    @JsonManagedReference
    private Role gradingRole;
    @JsonView(value={OrgView.OrgInfo.class})
    @JsonManagedReference
    private Role defaultOrgRole;

    @Id
    @Column(name="org_struct_id", nullable=false)
    @Basic
    public Long getOrgId() {
        return (Long)this.id;
    }

    public void setOrgId(Long orgId) {
        this.id = orgId;
    }

    @Basic
    @Column(name="tenant_id")
    public Long getTenantId() {
        return this.tenantId;
    }

    @Basic
    @Column(name="company_id")
    public Long getCompanyId() {
        return this.companyId;
    }

    @Basic
    @Column(name="grading_role_id")
    public Long getGradingRoleId() {
        return this.gradingRoleId;
    }

    @Basic
    @Column(name="default_org_role_id")
    public Long getDefaultOrgRoleId() {
        return this.defaultOrgRoleId;
    }

    @Basic
    @Column(name="org_code", nullable=false)
    public String getOrgCode() {
        return this.orgCode;
    }

    @Basic
    @Column(name="org_name", nullable=false)
    public String getOrgName() {
        return this.orgName;
    }

    @Basic
    @Column(name="parent_ids", nullable=false)
    public String getParentIds() {
        return this.parentIds;
    }

    @Basic
    @Column(name="parent_id")
    public Long getParentId() {
        return this.parentId != null && (Long)this.parentId > 0L ? (Long)this.parentId : null;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="org_type", nullable=false)
    @Basic
    public OrgType getOrgType() {
        return this.orgType;
    }

    @Basic
    @Column(name="org_biz_type")
    public String getOrgBizType() {
        return this.orgBizType;
    }

    @Basic
    @Column(name="org_desc", nullable=false)
    public String getOrgDesc() {
        return this.orgDesc;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="audit_status")
    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    @Basic
    @Column(name="enabled_time")
    public Date getEnabledTime() {
        return this.enabledTime;
    }

    @Basic
    @Column(name="disabled_time")
    public Date getDisabledTime() {
        return this.disabledTime;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    @Basic
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @JsonView(value={View.List.class, OrgView.OrgInfo.class})
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="sys_org_companyno", joinColumns={@JoinColumn(name="org_struct_id")})
    @Column(name="company_no", insertable=false, updatable=false)
    public Set<String> getCompanyNos() {
        return this.companyNos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_id", referencedColumnName="tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return this.tenant;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="company_id", referencedColumnName="company_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    @NotFound(action=NotFoundAction.IGNORE)
    public Company getCompany() {
        return this.company;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="grading_role_id", referencedColumnName="role_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Role getGradingRole() {
        return this.gradingRole;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="default_org_role_id", referencedColumnName="role_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Role getDefaultOrgRole() {
        return this.defaultOrgRole;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getParentName() {
        return this.parentName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getGradingRoleName() {
        if (this.gradingRoleName == null && this.gradingRole != null && this.gradingRole.isValid()) {
            this.gradingRoleName = this.gradingRole.getName();
        }
        return this.gradingRoleName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getDefaultOrgRoleName() {
        if (this.defaultOrgRoleName == null && this.defaultOrgRole != null && this.defaultOrgRole.isValid()) {
            this.defaultOrgRoleName = this.defaultOrgRole.getName();
        }
        return this.defaultOrgRoleName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getGradingRoleCode() {
        if (this.gradingRoleCode == null && this.gradingRole != null && this.gradingRole.isValid()) {
            this.gradingRoleCode = this.gradingRole.getCode();
        }
        return this.gradingRoleCode;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getDefaultOrgRoleCode() {
        if (this.defaultOrgRoleCode == null && this.defaultOrgRole != null && this.defaultOrgRole.isValid()) {
            this.defaultOrgRoleCode = this.defaultOrgRole.getCode();
        }
        return this.defaultOrgRoleCode;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getCompanyName() {
        if (this.companyName != null) {
            return this.companyName;
        }
        try {
            if (this.company != null) {
                this.companyName = this.company.getCompanyName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.companyName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getCompanyCode() {
        if (this.companyCode != null) {
            return this.companyCode;
        }
        try {
            if (this.company != null) {
                this.companyCode = this.company.getCompanyCode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.companyCode;
    }

    @JsonIgnore
    @Transient
    public boolean isCompanyLoaded() {
        return this.companyId != null && this.companyId > 0L && this.companyName != null;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTaxNum() {
        if (this.taxNum != null) {
            return this.taxNum;
        }
        try {
            if (this.company != null) {
                this.taxNum = this.company.getTaxNum();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.taxNum;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantName() {
        if (this.tenantName != null) {
            return this.tenantName;
        }
        try {
            if (this.tenant != null) {
                this.tenantName = this.tenant.getTenantName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.tenantName;
    }

    @JsonIgnore
    @Transient
    public boolean isTenantLoaded() {
        return this.tenantId != null && this.tenantId > 0L && this.tenantName != null;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantCode() {
        if (this.tenantCode != null) {
            return this.tenantCode;
        }
        try {
            if (this.tenant != null) {
                this.tenantCode = this.tenant.getTenantCode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.tenantCode;
    }

    public void setCompany(Company company) {
        this.company = company;
        if (company != null) {
            this.companyName = company.getCompanyName();
            this.companyCode = company.getCompanyCode();
            this.taxNum = company.getTaxNum();
        }
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
        if (tenant != null) {
            this.tenantName = tenant.getTenantName();
            this.tenantCode = tenant.getTenantCode();
        }
    }

    public void setGradingRole(Role gradingRole) {
        this.gradingRole = gradingRole;
        if (gradingRole != null) {
            this.gradingRoleName = gradingRole.getName();
            this.gradingRoleCode = gradingRole.getCode();
        }
    }

    public void setDefaultOrgRole(Role defaultOrgRole) {
        this.defaultOrgRole = defaultOrgRole;
        if (defaultOrgRole != null) {
            this.defaultOrgRoleName = defaultOrgRole.getName();
            this.defaultOrgRoleCode = defaultOrgRole.getCode();
        }
    }

    @JsonView(value={View.Info.class})
    @Transient
    public List<ServicePackage> getPackages() {
        return this.packages;
    }

    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="org")
    public List<OrgUserRel> getOrgUserRels() {
        return this.orgUserRels;
    }

    @JsonView(value={View.class})
    @Transient
    public List<OrgStruct> getParentOrgs() {
        return this.parentOrgs;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @JsonIgnore
    public void setBuiltParentIds(boolean builtParentIds) {
        this.builtParentIds = builtParentIds;
    }

    @JsonView(value={OrgView.OrgInfo.class})
    public void setPackages(List<ServicePackage> packages) {
        this.packages = packages;
    }

    @JsonIgnore
    public void setOrgUserRels(List<OrgUserRel> orgUserRels) {
        this.orgUserRels = orgUserRels;
    }
}

