/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.UserApp;
import com.xforceplus.entity.UserTag;
import com.xforceplus.jpa.listener.UserListener;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@EntityListeners(value={UserListener.class})
@NamedEntityGraphs(value={@NamedEntityGraph(name="User.graph", attributeNodes={@NamedAttributeNode(value="tenant"), @NamedAttributeNode(value="account")}), @NamedEntityGraph(name="User.graph.tenant", attributeNodes={@NamedAttributeNode(value="tenant")}), @NamedEntityGraph(name="User.graph.account", attributeNodes={@NamedAttributeNode(value="account")})})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="sys_user")
public class User
extends UserDto<OrgStruct, Role, Account>
implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "User.graph";
    public static final String NAMED_ENTITY_GRAPH_TENANT = "User.graph.tenant";
    public static final String NAMED_ENTITY_GRAPH_ACCOUNT = "User.graph.account";
    @ApiModelProperty(value="\u79df\u6237\u4fe1\u606f")
    @JsonView(value={View.class})
    @JsonManagedReference
    private Tenant tenant;
    @JsonIgnore
    private List<RoleUserRel> roleUserRels;
    @JsonIgnore
    private List<OrgUserRel> orgUserRels;
    @JsonIgnore
    private List<OrgVirtualNodeUserRel> orgVirtualNodeUserRels;
    @JsonIgnore
    private List<UserApp> userApps;
    @JsonIgnore
    @ApiModelProperty(value="\u7528\u6237\u6240\u5c5e\u7684\u89d2\u8272\u5173\u8054\u7684\u8d44\u6e90\u7801\u96c6\u5408")
    private Set<Resource> roleResources;
    @JsonIgnore
    @ApiModelProperty(value="\u7528\u6237\u5173\u8054\u7684\u7ec4\u7ec7\u4ee5\u53ca\u8be5\u7ec4\u7ec7\u7684\u4e0a\u7ea7\uff0c\u5305\u542b\u7684\u670d\u52a1\u5305\u96c6\u5408")
    private Set<ServicePackage> packages;
    @JsonIgnore
    @ApiModelProperty(value="\u7528\u6237\u5173\u8054\u7684\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u8d44\u6e90\u7801\u96c6\u5408")
    private Set<Resource> packageResources;
    @JsonIgnore
    private List<UserTag> userTags;
    @JsonIgnore
    @ApiModelProperty(value="\u7528\u6237\u7684\u89d2\u8272\u8d44\u6e90\u7801\u4e0e\u7ec4\u7ec7\u6743\u9650\u8d44\u6e90\u7801\u7684\u4ea4\u96c6")
    private Map<Long, Set<String>> appResources;
    @ApiModelProperty(hidden=true)
    private int cachedExtraInfoDimension;

    @Id
    @Column(name="user_id", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Min(value=1L)
    @NotNull
    @Basic
    @Column(name="tenant_id", nullable=false)
    public @Min(value=1L) @NotNull Long getTenantId() {
        return this.tenantId;
    }

    @Min(value=1L)
    @NotNull
    @Basic
    @Column(name="account_id", nullable=false)
    public @Min(value=1L) @NotNull Long getAccountId() {
        return this.accountId;
    }

    @Basic
    @Column(name="user_code")
    public String getUserCode() {
        return this.userCode;
    }

    @Basic
    @Column(name="user_number")
    public String getUserNumber() {
        return this.userNumber;
    }

    @Basic
    @Column(name="user_name")
    public String getUserName() {
        return this.userName;
    }

    @Basic
    @Column(name="user_phone")
    public String getUserPhone() {
        return this.userPhone;
    }

    @Basic
    @Column(name="user_sex")
    public Integer getUserSex() {
        return this.userSex;
    }

    @Basic
    @Column(name="user_email_addr")
    public String getUserEmailAddr() {
        return this.userEmailAddr;
    }

    @Basic
    @Column(name="user_id_card")
    public String getUserIdCard() {
        return this.userIdCard;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="user_period_time")
    public Date getUserPeriodTime() {
        return this.userPeriodTime;
    }

    @Basic
    @Column(name="user_work_tel")
    public String getUserWorkTel() {
        return this.userWorkTel;
    }

    @Basic
    @Column(name="active_status")
    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="contact_addr")
    public String getContactAddr() {
        return this.contactAddr;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="expired_date")
    public Date getExpiredDate() {
        return this.expiredDate;
    }

    @JsonView(value={View.class})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return this.tenant;
    }

    @JsonView(value={View.class})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Account getAccount() {
        return (Account)this.account;
    }

    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    public List<RoleUserRel> getRoleUserRels() {
        return this.roleUserRels;
    }

    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    public List<OrgUserRel> getOrgUserRels() {
        return this.orgUserRels;
    }

    @JsonView(value={UserView.UserInfo.class})
    @Transient
    public Map<Long, Set<String>> getAppResources() {
        return this.appResources;
    }

    @JsonView(value={UserView.UserInfo.class})
    @Transient
    public Set<String> getResourceCodes() {
        return this.resourceCodes;
    }

    @JsonView(value={UserView.UserInfo.class})
    @Transient
    public Set<Resource> getRoleResources() {
        return this.roleResources;
    }

    @JsonView(value={UserView.UserInfo.class})
    @Transient
    public Set<ServicePackage> getPackages() {
        return this.packages;
    }

    @JsonView(value={UserView.UserInfo.class})
    @Transient
    public Set<Resource> getPackageResources() {
        return this.packageResources;
    }

    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    public List<UserApp> getUserApps() {
        return this.userApps;
    }

    @JsonView(value={UserView.UserInfo.class, TokenView.class})
    @Transient
    public String getTenantName() {
        this.tenantName = this.tenant != null ? this.tenant.getTenantName() : null;
        return this.tenantName;
    }

    @JsonView(value={UserView.UserInfo.class, TokenView.class})
    @Transient
    public String getTenantCode() {
        this.tenantCode = this.tenant != null ? this.tenant.getTenantCode() : null;
        return this.tenantCode;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
        if (tenant != null) {
            this.tenantCode = tenant.getTenantCode();
            this.tenantName = tenant.getTenantName();
        }
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    public List<UserTag> getUserTags() {
        return this.userTags;
    }

    @Transient
    public int getCachedExtraInfoDimension() {
        return this.cachedExtraInfoDimension;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    public List<OrgVirtualNodeUserRel> getOrgVirtualNodeUserRels() {
        return this.orgVirtualNodeUserRels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User that = (User)o;
        if (this.id == null || this.id == 0L) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @JsonIgnore
    public void setRoleUserRels(List<RoleUserRel> roleUserRels) {
        this.roleUserRels = roleUserRels;
    }

    @JsonIgnore
    public void setOrgUserRels(List<OrgUserRel> orgUserRels) {
        this.orgUserRels = orgUserRels;
    }

    @JsonIgnore
    public void setOrgVirtualNodeUserRels(List<OrgVirtualNodeUserRel> orgVirtualNodeUserRels) {
        this.orgVirtualNodeUserRels = orgVirtualNodeUserRels;
    }

    @JsonIgnore
    public void setUserApps(List<UserApp> userApps) {
        this.userApps = userApps;
    }

    @JsonIgnore
    public void setRoleResources(Set<Resource> roleResources) {
        this.roleResources = roleResources;
    }

    @JsonIgnore
    public void setPackages(Set<ServicePackage> packages) {
        this.packages = packages;
    }

    @JsonIgnore
    public void setPackageResources(Set<Resource> packageResources) {
        this.packageResources = packageResources;
    }

    @JsonIgnore
    public void setUserTags(List<UserTag> userTags) {
        this.userTags = userTags;
    }

    @JsonIgnore
    public void setAppResources(Map<Long, Set<String>> appResources) {
        this.appResources = appResources;
    }

    public void setCachedExtraInfoDimension(int cachedExtraInfoDimension) {
        this.cachedExtraInfoDimension = cachedExtraInfoDimension;
    }
}

