/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.entity.App;
import com.xforceplus.entity.User;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="bss_in_user_app_rel")
public class UserApp
implements Serializable {
    private Long id;
    private Long userId;
    private Long appId;
    @JsonIgnore
    private App app;
    @JsonIgnore
    private User user;

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getId() {
        return this.id;
    }

    @Basic
    @Column(name="in_user_id", nullable=false)
    public Long getUserId() {
        return this.userId;
    }

    @Basic
    @Column(name="app_id", nullable=false)
    public Long getAppId() {
        return this.appId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="app_id", referencedColumnName="app_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public App getApp() {
        return this.app;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="in_user_id", referencedColumnName="user_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserApp userApp = (UserApp)o;
        return Objects.equals(this.userId, userApp.userId) && Objects.equals(this.appId, userApp.appId);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.appId);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @JsonIgnore
    public void setApp(App app) {
        this.app = app;
    }

    @JsonIgnore
    public void setUser(User user) {
        this.user = user;
    }
}

