/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Account;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;

public class AccountListener
extends OperatorListener<Account> {
    @PrePersist
    public void prePersist(Account entity) {
        if (entity.getAccountId() == null) {
            long id = SnowflakeGenerator.id();
            entity.setAccountId(id);
        }
        if (StringUtils.isBlank((CharSequence)entity.getUsername())) {
            entity.setUsername("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTelPhone())) {
            entity.setTelPhone("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getEmail())) {
            entity.setEmail("");
        }
        if (entity.getBindAuthFlag() == null) {
            entity.setBindAuthFlag(false);
        }
        if (entity.getChangePasswordFlag() == null) {
            entity.setChangePasswordFlag(false);
        }
        if (entity.getDoubleAuthFlag() == null) {
            entity.setDoubleAuthFlag(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        this.cleanRelatedEntities(entity);
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Account entity) {
        if (StringUtils.isBlank((CharSequence)entity.getUsername())) {
            entity.setUsername("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTelPhone())) {
            entity.setTelPhone("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getEmail())) {
            entity.setEmail("");
        }
        this.cleanRelatedEntities(entity);
        super.beforeUpdate(entity);
    }

    private void cleanRelatedEntities(Account entity) {
        entity.setUsers(null);
    }
}

