/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Calendar;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

public class CompanyTenantRelOperationListener {
    @PrePersist
    public void prePersist(CompanyTenantRelOperation entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreaterName("");
            }
            entity.setCreaterTenantId(authorizedUser.getTenantId());
            entity.setCreaterTenantName(authorizedUser.getTenantName());
        }
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyTenantRelOperation entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setAuditorId(authorizedUser.getId());
            if (authorizedUser.getOperaterName() != null) {
                entity.setAuditorName(authorizedUser.getOperaterName());
            } else {
                entity.setAuditorName("");
            }
            entity.setAuditorTenantId(authorizedUser.getTenantId());
            entity.setAuditorTenantName(authorizedUser.getTenantName());
            entity.setAuditTime(Calendar.getInstance().getTime());
        }
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(CompanyTenantRelOperation entity) {
        entity.setCompany(null);
    }
}

