package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.company.Relation;
import com.xforceplus.jpa.listener.CompanyListener;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.*;
import org.hibernate.envers.Audited;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = Company.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode("hostTenant")
                }
        )})
@DynamicInsert
@DynamicUpdate
@Setter
@Entity
@Table(name = "bss_company")
public class Company extends CompanyDto<OrgStruct> implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "Company.graph";

    @JsonIgnore
    private List<OrgStruct> orgs;

    @JsonView(View.Info.class)
    private List<String> companyNos;

    @JsonIgnore
    private List<CompanyTenantRel> tenantRels;

    @JsonIgnore
    private Tenant hostTenant;

    @ApiModelProperty(value = "关联租户集合")
    @JsonView({View.Info.class})
    private List<Tenant> tenants;


    @Override
    @Id
    @Column(name = "company_id", nullable = false)
    public Long getCompanyId() {
        return companyId;
    }

    @Override
    @NotNull
    @Basic
    @Column(name = "company_code", nullable = false)
    public String getCompanyCode() {
        return companyCode;
    }

    @Override
    @NotNull
    @Audited
    @Basic
    @Column(name = "company_name", nullable = false)
    public String getCompanyName() {
        return companyName;
    }

    @Override
    @NotNull
    @Audited
    @Basic
    @Column(name = "tax_num")
    public String getTaxNum() {
        return taxNum;
    }

    @Override
    @Audited
    @Basic
    @Column(name = "host_tenant_id")
    public Long getHostTenantId() {
        return hostTenantId;
    }

    @Override
    @Basic
    @Column(name = "location_area")
    public String getLocationArea() {
        return locationArea;
    }

    @Override
    @Basic
    @Column(name = "location_city")
    public String getLocationCity() {
        return locationCity;
    }

    @Override
    @Basic
    @Column(name = "location_addr")
    public String getLocationAddr() {
        return locationAddr;
    }

    @Override
    @Basic
    @Column(name = "company_phone")
    public String getCompanyPhone() {
        return companyPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_start_time")
    public Date getBusinessStartTime() {
        return businessStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_end_time")
    public Date getBusinessEndTime() {
        return businessEndTime;
    }

    @Override
    @Basic
    @Column(name = "business_time_long")
    public Integer getBusinessTimeLong() {
        return businessTimeLong;
    }

    @Override
    @Basic
    @Column(name = "business_scope")
    public String getBusinessScope() {
        return businessScope;
    }

    @Override
    @Basic
    @Column(name = "company_logo")
    public String getCompanyLogo() {
        return companyLogo;
    }

    @Override
    @Basic
    @Column(name = "business_license")
    public String getBusinessLicense() {
        return businessLicense;
    }

    @Override
    @Basic
    @Column(name = "plat_manager_status")
    public Integer getPlatManagerStatus() {
        return platManagerStatus;
    }

    @Override
    @Basic
    @Column(name = "manager_location")
    public String getManagerLocation() {
        return managerLocation;
    }

    @Override
    @Basic
    @Column(name = "manager_name")
    public String getManagerName() {
        return managerName;
    }

    @Override
    @Basic
    @Column(name = "manager_card_type")
    public String getManagerCardType() {
        return managerCardType;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card")
    public String getManagerIdCard() {
        return managerIdCard;
    }

    @Override
    @Basic
    @Column(name = "manager_phone")
    public String getManagerPhone() {
        return managerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_start_time")
    public Date getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_end_time")
    public Date getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_time_long")
    public Integer getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_front_photo")
    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_back_photo")
    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    @Override
    @Basic
    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    @Override
    @Basic
    @Column(name = "bank_branch_name")
    public String getBankBranchName() {
        return bankBranchName;
    }

    @Override
    @Basic
    @Column(name = "bank_no")
    public String getBankNo() {
        return bankNo;
    }

    @Override
    @Basic
    @Column(name = "bank_area")
    public String getBankArea() {
        return bankArea;
    }

    @Override
    @Basic
    @Column(name = "bank_city")
    public String getBankCity() {
        return bankCity;
    }

    @Override
    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @Override
    @Basic
    @Column(name = "tradition_authen_flag")
    public Integer getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    @Override
    @Basic
    @Column(name = "inspection_service_flag")
    public Integer getInspectionServiceFlag() {
        return inspectionServiceFlag;
    }

    @Override
    @Basic
    @Column(name = "speed_inspection_channel_flag")
    public Integer getSpeedInspectionChannelFlag() {
        return speedInspectionChannelFlag;
    }

    @Override
    @Basic
    @Audited
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "cquota", precision = 2)
    public BigDecimal getCquota() {
        return cquota;
    }

    @Override
    @Basic
    @Column(name = "squota", precision = 2)
    public BigDecimal getSquota() {
        return squota;
    }

    @Override
    @Basic
    @Column(name = "ce_quota", precision = 2)
    public BigDecimal getCeQuota() {
        return ceQuota;
    }

    @Override
    @Basic
    @Column(name = "ju_quota", precision = 2)
    public BigDecimal getJuQuota() {
        return juQuota;
    }

    @Override
    @Basic
    @Column(name = "se_quota", precision = 2)
    public BigDecimal getSeQuota() {
        return seQuota;
    }

    @Override
    @Basic
    @Column(name = "vehicle_limit", precision = 2)
    public BigDecimal getVehicleLimit() {
        return vehicleLimit;
    }

    @Override
    @Basic
    @Column(name = "regist_location_area")
    public String getRegistLocationArea() {
        return registLocationArea;
    }

    @Override
    @Basic
    @Column(name = "regist_location_city")
    public String getRegistLocationCity() {
        return registLocationCity;
    }

    @Override
    @Basic
    @Column(name = "regist_location_addr")
    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification_type")
    public Integer getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification")
    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_name")
    public String getProxyManagerName() {
        return proxyManagerName;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_card_type")
    public String getProxyManagerCardType() {
        return proxyManagerCardType;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card")
    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_phone")
    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_start_time")
    public Date getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_end_time")
    public Date getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_time_long")
    public Integer getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_front_photo")
    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_back_photo")
    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Audited
    @Temporal(TemporalType.DATE)
    @Column(name = "effective_date")
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    @Override
    @Audited
    @Basic
    @Column(name = "is_effective")
    public Boolean getEffective() {
        return effective;
    }

    @Override
    @Basic
    @Column(name = "identification_type")
    public String getIdentificationType() {
        return identificationType;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "company")
    public List<OrgStruct> getOrgs() {
        return orgs;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "company")
    public List<CompanyTenantRel> getTenantRels() {
        return tenantRels;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "host_tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @NotFound(action = NotFoundAction.IGNORE)
    public Tenant getHostTenant() {
        return this.hostTenant;
    }

    @Transient
    public List<Tenant> getTenants() {
        return tenants;
    }

    @ApiModelProperty(value = "关联租户集合")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView({View.List.class, View.Page.class})
    @Transient
    public Set<Tenant> getRelatedTenants() {
        if (this.relations == null || this.relations.isEmpty()) {
            return null;
        }
        Set<Tenant> tenants = new HashSet<>();
        for (Relation<OrgStruct> relation : this.relations) {
            if (relation.getTenantId() == null || relation.getTenantId().equals(this.hostTenantId)) {
                continue;
            }
            Tenant tenant = new Tenant();
            tenant.setTenantId(relation.getTenantId());
            tenant.setTenantName(relation.getTenantName());
            tenant.setTenantCode(relation.getTenantCode());
            tenants.add(tenant);
        }
        return tenants;
    }

    @Transient
    public List<String> getCompanyNos() {
        return companyNos;
    }

    @Transient
    public void postLoad() {
        if (this.hostTenant != null) {
            this.hostTenantName = this.hostTenant.getTenantName();
            this.hostTenantCode = this.hostTenant.getTenantCode();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
