package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.jpa.listener.CompanyApplyListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@SuppressWarnings("all")
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyApplyListener.class})
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_company_apply")
public class CompanyApply extends CompanyDto<OrgStruct> implements Serializable {
    private Long companyApplyId;
    private Long orgStructId;
    private String accountNum;
    private String password;
    private String tenantCode;

    @Id
    @Column(name = "company_apply_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getCompanyApplyId() {
        return companyApplyId;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Basic
    @Column(name = "org_struct_id")
    public Long getOrgStructId() {
        return (orgStructId != null && orgStructId > 0) ? orgStructId : null;
    }

    @Basic
    @Column(name = "tenant_name")
    public String getTenantName() {
        return hostTenantName;
    }

    @Basic
    @Column(name = "account_num")
    public String getAccountNum() {
        return accountNum;
    }

    @Basic
    @Column(name = "password")
    public String getPassword() {
        return password;
    }

    @Basic
    @Column(name = "tenant_code")
    public String getTenantCode() {
        return tenantCode;
    }

    @Override
    @Basic
    @Column(name = "company_id")
    public Long getCompanyId() {
        return (companyId != null && companyId > 0) ? companyId : null;
    }

    @Override
    @Basic
    @Column(name = "company_name", nullable = false)
    public String getCompanyName() {
        return companyName;
    }

    @Override
    @Basic
    @Column(name = "tax_num")
    public String getTaxNum() {
        return taxNum;
    }

    @Override
    @Basic
    @Column(name = "location_area")
    public String getLocationArea() {
        return locationArea;
    }

    @Override
    @Basic
    @Column(name = "location_city")
    public String getLocationCity() {
        return locationCity;
    }

    @Override
    @Basic
    @Column(name = "location_addr")
    public String getLocationAddr() {
        return locationAddr;
    }

    @Override
    @Basic
    @Column(name = "company_phone")
    public String getCompanyPhone() {
        return companyPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_start_time")
    public Date getBusinessStartTime() {
        return businessStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_end_time")
    public Date getBusinessEndTime() {
        return businessEndTime;
    }

    @Override
    @Basic
    @Column(name = "business_time_long")
    public Integer getBusinessTimeLong() {
        return businessTimeLong;
    }

    @Override
    @Basic
    @Column(name = "business_scope")
    public String getBusinessScope() {
        return businessScope;
    }

    @Override
    @Basic
    @Column(name = "company_logo")
    public String getCompanyLogo() {
        return companyLogo;
    }

    @Override
    @Basic
    @Column(name = "business_license")
    public String getBusinessLicense() {
        return businessLicense;
    }

    @Override
    @Basic
    @Column(name = "plat_manager_status")
    public Integer getPlatManagerStatus() {
        return platManagerStatus;
    }

    @Override
    @Basic
    @Column(name = "manager_location")
    public String getManagerLocation() {
        return managerLocation;
    }

    @Override
    @Basic
    @Column(name = "manager_name")
    public String getManagerName() {
        return managerName;
    }

    @Override
    @Basic
    @Column(name = "manager_card_type")
    public String getManagerCardType() {
        return managerCardType;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card")
    public String getManagerIdCard() {
        return managerIdCard;
    }

    @Override
    @Basic
    @Column(name = "manager_phone")
    public String getManagerPhone() {
        return managerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_start_time")
    public Date getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_end_time")
    public Date getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_time_long")
    public Integer getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_front_photo")
    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_back_photo")
    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    @Override
    @Basic
    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    @Override
    @Basic
    @Column(name = "bank_branch_name")
    public String getBankBranchName() {
        return bankBranchName;
    }

    @Override
    @Basic
    @Column(name = "bank_no")
    public String getBankNo() {
        return bankNo;
    }

    @Override
    @Basic
    @Column(name = "bank_area")
    public String getBankArea() {
        return bankArea;
    }

    @Override
    @Basic
    @Column(name = "bank_city")
    public String getBankCity() {
        return bankCity;
    }

    @Override
    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @Override
    @ApiModelProperty(value = "审核状态", notes = "暂存  1：审核中  2：审核不通过 3：审核通过")
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "cquota", precision = 2)
    public BigDecimal getCquota() {
        return cquota;
    }

    @Override
    @Basic
    @Column(name = "squota", precision = 2)
    public BigDecimal getSquota() {
        return squota;
    }

    @Override
    @Basic
    @Column(name = "ce_quota", precision = 2)
    public BigDecimal getCeQuota() {
        return ceQuota;
    }

    @Override
    @Basic
    @Column(name = "ju_quota", precision = 2)
    public BigDecimal getJuQuota() {
        return juQuota;
    }

    @Override
    @Basic
    @Column(name = "se_quota", precision = 2)
    public BigDecimal getSeQuota() {
        return seQuota;
    }

    @Override
    @Basic
    @Column(name = "vehicle_limit", precision = 2)
    public BigDecimal getVehicleLimit() {
        return vehicleLimit;
    }

    @Override
    @Basic
    @Column(name = "regist_location_area")
    public String getRegistLocationArea() {
        return registLocationArea;
    }

    @Override
    @Basic
    @Column(name = "regist_location_city")
    public String getRegistLocationCity() {
        return registLocationCity;
    }

    @Override
    @Basic
    @Column(name = "regist_location_addr")
    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification_type")
    public Integer getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification")
    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_name")
    public String getProxyManagerName() {
        return proxyManagerName;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_card_type")
    public String getProxyManagerCardType() {
        return proxyManagerCardType;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card")
    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_phone")
    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_start_time")
    public Date getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_end_time")
    public Date getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_time_long")
    public Integer getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_front_photo")
    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_back_photo")
    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name")
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompanyApply that = (CompanyApply) o;
        return Objects.equals(companyApplyId, that.companyApplyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), companyApplyId);
    }
}
