package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.company.CompanyTenantRelOperationDto;
import com.xforceplus.jpa.listener.CompanyTenantRelOperationListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.util.Date;

/**
 * 公司租户关联关系操作记录 Entity
 *
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyTenantRelOperationListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "company_tenant_rel_operation")
public class CompanyTenantRelOperation extends CompanyTenantRelOperationDto {

    @JsonIgnore
    private Company company;

    @Override
    @Id
    @Column(name = "id", nullable = false, updatable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    /**
     * 邀请方公司id
     * @return 邀请方公司id
     */
    @Override
    @Basic
    @Column(name = "inviting_company_id", updatable = false)
    public Long getInvitingCompanyId() {
        return invitingCompanyId;
    }


    /**
     * 邀请方公司名称
     * @return 邀请方公司名称
     */
    @Override
    @Basic
    @Column(name = "inviting_company_name", updatable = false)
    public String getInvitingCompanyName() {
        return invitingCompanyName;
    }

    /**
     * 关联公司id
     * @return 关联公司id
     */
    @Override
    @Basic
    @Column(name = "company_id", nullable = false, updatable = false)
    public Long getCompanyId() {
        return companyId;
    }

    /**
     * 关联公司名称
     * @return 关联公司名称
     */
    @Override
    @Basic
    @Column(name = "company_name", nullable = false, updatable = false)
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 关联公司编码
     * @return 关联公司编码
     */
    @Override
    @Basic
    @Column(name = "company_code", nullable = false, updatable = false)
    public String getCompanyCode() {
        return companyCode;
    }

    /**
     * 关联公司税号
     * @return 关联公司税号
     */
    @Override
    @Basic
    @Column(name = "tax_num", nullable = false, updatable = false)
    public String getTaxNum() {
        return taxNum;
    }

    /**
     * 关联租户id
     * @return 关联租户id
     */
    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false, updatable = false)
    public Long getTenantId() {
        return tenantId;
    }

    /**
     * 关联租户名称
     * @return 关联租户名称
     */
    @Override
    @Basic
    @Column(name = "tenant_name", nullable = false, updatable = false)
    public String getTenantName() {
        return tenantName;
    }

    /**
     * 关联租户代码
     * @return 关联租户代码
     */
    @Override
    @Basic
    @Column(name = "tenant_code", nullable = false, updatable = false)
    public String getTenantCode() {
        return tenantCode;
    }

    /**
     * 被关联租户id
     * @return 被关联租户id
     */
    @Override
    @Basic
    @Column(name = "related_tenant_id", nullable = false, updatable = false)
    public Long getRelatedTenantId() {
        return relatedTenantId;
    }

    /**
     * 被关联租户名称
     * @return 被关联租户名称
     */
    @Override
    @Basic
    @Column(name = "related_tenant_name", nullable = false, updatable = false)
    public String getRelatedTenantName() {
        return relatedTenantName;
    }

    /**
     * 被关联租户代码
     * @return 被关联租户代码
     */
    @Override
    @Basic
    @Column(name = "related_tenant_code", nullable = false, updatable = false)
    public String getRelatedTenantCode() {
        return relatedTenantCode;
    }

    /**
     * 被关联公司名称
     * @return 被关联公司名称
     */
    @Override
    @Basic
    @Column(name = "related_company_id", nullable = false, updatable = false)
    public Long getRelatedCompanyId() {
        return relatedCompanyId;
    }

    @Override
    @Basic
    @Column(name = "related_company_name", nullable = false, updatable = false)
    public String getRelatedCompanyName() {
        return relatedCompanyName;
    }

    /**
     * 被关联公司编码
     * @return 被关联公司编码
     */
    @Override
    @Basic
    @Column(name = "related_company_code", nullable = false, updatable = false)
    public String getRelatedCompanyCode() {
        return relatedCompanyCode;
    }
    /**
     * 被关联公司税号
     * @return 被关联公司税号
     */
    @Override
    @Basic
    @Column(name = "related_tax_num", nullable = false, updatable = false)
    public String getRelatedTaxNum() {
        return relatedTaxNum;
    }

    /**
     * 开关组合
     * @return 开关组合
     */
    @Override
    @Basic
    @Column(name = "switches", nullable = false)
    public Integer getSwitches() {
        return switches;
    }

    /**
     * 共享历史发票起始日期
     * @return 共享历史发票起始日期
     */
    @Override
    @Temporal(TemporalType.DATE)
    @Column(name = "invoice_start_date")
    public Date getInvoiceStartDate() {
        return invoiceStartDate;
    }

    /**
     * 共享历史结算单起始日期
     * @return 共享历史结算单起始日期
     */
    @Override
    @Temporal(TemporalType.DATE)
    @Column(name = "statement_start_date")
    public Date getStatementStartDate() {
        return statementStartDate;
    }

    /**
     * 操作类型
     * @return 操作类型
     */
    @Override
    @Basic
    @Column(name = "operation_type", nullable = false)
    public Integer getOperationType() {
        return operationType;
    }

    /**
     * 审核状态
     * @return 审核状态
     */
    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    /**
     * 邀请备注
     * @return 邀请备注
     */
    @Override
    @Basic
    @Column(name = "invite_remark")
    public String getInviteRemark() {
        return inviteRemark;
    }

    /**
     * 审核备注
     * @return 审核备注
     */
    @Override
    @Basic
    @Column(name = "audit_remark")
    public String getAuditRemark() {
        return auditRemark;
    }

    /**
     * 创建人id
     * @return 创建人id
     */
    @Override
    @Basic
    @Column(name = "creater_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    /**
     * 创建人名称
     * @return 创建人名称
     */
    @Override
    @Basic
    @Column(name = "creater_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    /**
     * 创建时间
     * @return 创建时间
     */
    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 创建人租户id
     * @return 创建人租户id
     */
    @Override
    @Basic
    @Column(name = "creater_tenant_id", updatable = false)
    public Long getCreaterTenantId() {
        return createrTenantId;
    }

    /**
     * 创建人租户名称
     * @return 创建人租户名称
     */
    @Override
    @Basic
    @Column(name = "creater_tenant_name", updatable = false)
    public String getCreaterTenantName() {
        return createrTenantName;
    }

    /**
     * 审核人id
     * @return 审核人id
     */
    @Override
    @Basic
    @Column(name = "auditor_id")
    public Long getAuditorId() {
        return auditorId;
    }

    /**
     * 审核人名称
     * @return 审核人名称
     */
    @Override
    @Basic
    @Column(name = "auditor_name")
    public String getAuditorName() {
        return auditorName;
    }

    /**
     * 审核时间
     * @return 审核时间
     */
    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "audit_time")
    public Date getAuditTime() {
        return auditTime;
    }

    /**
     * 审核人租户id
     * @return 审核人租户id
     */
    @Override
    @Basic
    @Column(name = "auditor_tenant_id")
    public Long getAuditorTenantId() {
        return auditorTenantId;
    }

    /**
     * 审核人租户名称
     * @return 审核人租户名称
     */
    @Override
    @Basic
    @Column(name = "auditor_tenant_name")
    public String getAuditorTenantName() {
        return auditorTenantName;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Company getCompany() {
        return company;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
