package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.OrgUserRelListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({OrgUserRelListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_user_rel")
public class OrgUserRel implements Serializable {
    private Long id;
    private Long tenantId;
    private Long orgStructId;
    private Long userId;
    private Boolean fullSelectedFlag;

    @JsonIgnore
    private OrgStruct org;

    @JsonIgnore
    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @Basic
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return (orgStructId != null && orgStructId > 0) ? orgStructId : null;
    }

    @Basic
    @Column(name = "user_id", nullable = false)
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "full_selected_flag")
    public Boolean getFullSelectedFlag() {
        return fullSelectedFlag;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return org;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgUserRel that = (OrgUserRel) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(orgStructId, that.orgStructId) &&
                        Objects.equals(userId, that.userId);
            }
        } else {
            return id.equals(that.id);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgStructId, userId);
    }
}
