package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.RoleUserRelListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({RoleUserRelListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role_user_rel")
public class RoleUserRel {
    private Long id;
    private Long roleId;
    private Long userId;
    private Long userGroupId;
    private Long tenantId;
    private int relType;
    private Long orgId;
    private String createId;
    private String createName;
    private Date createTime;

    @JsonIgnore
    private Role role;

    @JsonIgnore
    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "role_id", nullable = false)
    public Long getRoleId() {
        return (roleId != null && roleId > 0) ? roleId : null;
    }

    @Basic
    @Column(name = "user_id", nullable = false)
    public Long getUserId() {
        return (userId != null && userId > 0) ? userId : null;
    }

    @Basic
    @Column(name = "user_group_id")
    public Long getUserGroupId() {
        return userGroupId;
    }

    @Basic
    @Column(name = "rel_type", nullable = false)
    public int getRelType() {
        return relType;
    }

    @Basic
    @Column(name = "org_struct_id")
    public Long getOrgId() {
        return orgId;
    }

    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @Basic
    @Column(name = "create_user_id")
    public String getCreateId() {
        return createId;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreateName() {
        return createName;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getRole() {
        return role;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleUserRel that = (RoleUserRel) o;
        return roleId.equals(that.roleId) && userId.equals(that.userId) && Objects.equals(orgId, that.orgId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId, userId);
    }

    @Override
    public String toString() {
        return "RoleUserRel{" + "id=" + id + ", roleId=" + roleId + ", userId=" + userId + ", userGroupId=" + userGroupId + ", tenantId=" + tenantId + ", relType=" + relType + ", orgId=" + orgId + ", role=" + role + '}';
    }
}
