package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.conf.PrivacyAgreementDto;
import com.xforceplus.domain.conf.SysEnumDto;
import com.xforceplus.jpa.listener.PrivacyAgreementListener;
import com.xforceplus.jpa.listener.SysEnumListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
 * 隐私协议实体类
 *
 * @author HWT
 * @since 2022/1/06 15:50
 */
@EntityListeners({SysEnumListener.class})
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_enum")
public class SysEnum extends SysEnumDto implements Serializable {
    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @JsonView(View.class)
    public Long getId() {
        return id;
    }


    @Override
    @Basic
    @Column(name = "enum_group_name",  nullable = false)
    @JsonView(View.class)
    public String getEnumGroupName() {
        return enumGroupName;
    }

    @Override
    @Basic
    @Column(name = "enum_name",  nullable = false)
    @JsonView(View.class)
    public String getEnumName() {
        return enumName;
    }
    @Override
    @Basic
    @Column(name = "enum_value",  nullable = false)
    @JsonView(View.class)
    public String getEnumValue() {
        return enumValue;
    }

    @Override
    @Basic
    @Column(name = "enum_type",  nullable = false)
    @JsonView(View.class)
    public String getEnumType() {
        return enumType;
    }

    @Override
    @Basic
    @Column(name = "enum_seq", nullable = false)
    @JsonView(View.class)
    public Integer getEnumSeq() {
        return enumSeq;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }
}
