package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.jpa.listener.UserTagListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({UserTagListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_user_tag")
public class UserTag implements Serializable {
    @JsonView(View.class)
    private Long id;
    private Long userId;
    @JsonView(View.class)
    private String tagName;
    @JsonView(View.class)
    private String tagValue;

    @JsonIgnore
    private User user;

    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "user_tag_id")
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "tag_name")
    public String getTagName() {
        return tagName;
    }

    @Basic
    @Column(name = "tag_value")
    public String getTagValue() {
        return tagValue;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserTag userTag = (UserTag) o;
        return Objects.equals(userId, userTag.userId) &&
                Objects.equals(tagName, userTag.tagName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, tagName);
    }
}
