package com.xforceplus.event.model;

import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.history.RevisionMetadata;


/**
 * 持久化实体保存后事件对象
 * @param <T>
 * @author geewit
 */
@Setter
@Getter
public class EntityPostSaveEvent<T> extends ApplicationEvent {
    private RevisionMetadata.RevisionType revisionType;

    public EntityPostSaveEvent(RevisionMetadata.RevisionType revisionType, T entity) {
        super(entity);
        this.revisionType = revisionType;
    }
}
