package com.xforceplus.jpa.listener;


import com.xforceplus.entity.CompanyApply;
import io.geewit.utils.uuid.UUIDUtils;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 公司自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class CompanyApplyListener extends OperatorListener<CompanyApply> {
    @PrePersist
    public void prePersist(CompanyApply entity) {
        if (StringUtils.isBlank(entity.getCompanyCode())) {
            entity.setCompanyCode(UUIDUtils.randomUUID());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank(entity.getTaxNum())) {
            throw new IllegalArgumentException("公司税号不能为空");
        }
        if (StringUtils.isBlank(entity.getCompanyName())) {
            throw new IllegalArgumentException("公司名称不能为空");
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyApply entity) {
        super.beforeUpdate(entity);
    }
}