package com.xforceplus.jpa.listener;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.envers.EnversRevisionEntity;
import org.hibernate.envers.RevisionListener;


/**
 * hibernate envers 的 {@link RevisionListener}
 *
 * @author geewit
 * @since 2020-11-09
 */
public class GlobalRevisionListener implements RevisionListener {
    @SuppressWarnings({"unchecked"})
    @Override
    public void newRevision(Object revisionEntity) {
        EnversRevisionEntity<Long> globalRevisionEntity = (EnversRevisionEntity<Long>) revisionEntity;
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            globalRevisionEntity.setOperatorId(authorizedUser.getId());
            globalRevisionEntity.setOperatorName(authorizedUser.getOperaterName());
        }
    }
}
