package com.xforceplus.jpa.listener;

import com.xforceplus.entity.OrgCompanyRel;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class OrgCompanyRelListener {
    @PrePersist
    public void prePersist(OrgCompanyRel entity) {
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(OrgCompanyRel entity) {
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(OrgCompanyRel entity) {
        entity.setOrg(null);
    }
}