package com.xforceplus.jpa.listener;


import com.google.common.hash.Hashing;
import com.xforceplus.entity.PasswordHistory;

import javax.persistence.PrePersist;
import java.nio.charset.StandardCharsets;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class PasswordHistoryListener {
    @SuppressWarnings("deprecation")
    @PrePersist
    public void prePersist(PasswordHistory entity) {
        if (entity.getAccountId() != null && entity.getPassword() != null) {

            String hash = Hashing.sha1()
                    .hashString(entity.getAccountId() + "_" + entity.getPassword(), StandardCharsets.UTF_8)
                    .toString();
            entity.setId(hash);
        }
    }
}