/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgCompanyDTO.java   2020-11-26 14-40-58
 * Author: Evan
 */
package com.xforceplus.dto.org;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * <p>
 * Title: OrgCompanyDTO
 * </p>
 * <p>
 * Description: OrgCompanyDTO(租户ID、公司ID、公司名称、公司CODE、组织ID（列表， ID 倒叙、组织名称、组织CODE）)
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-11-26 14-40-58
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class OrgCompanyDTO {

    /**
     * 租户Id
     */
    @ApiModelProperty("租户Id")
    private Long tenantId;
    /**
     * 公司Id
     */
    @ApiModelProperty("公司Id")
    private Long companyId;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    /**
     * 公司代码
     */
    @ApiModelProperty("组织ID")
    private String companyCode;
    /**
     * 组织ID
     */
    @ApiModelProperty("组织ID")
    private Long orgId;
    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 组织代码
     */
    @ApiModelProperty("组织代码")
    private String orgCode;
    /**
     * 公司companyNos列表
     */
    @ApiModelProperty("公司编号")
    private List<String> companyNos;
}
