package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.jpa.listener.AccountListener;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({AccountListener.class})
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_sass_account")
public class Account extends AccountDto implements Serializable {

    /**
     * 密码原文
     */
    @JsonIgnore
    private String rawPassword;

    @JsonIgnore
    private Long tenantId;

    @JsonIgnore
    private List<User> users;

    @Override
    @Id
    @Column(name = "account_id", unique = true, nullable = false)
    public Long getAccountId() {
        return accountId;
    }

    @Override
    @Basic
    @Column(name = "email")
    public String getEmail() {
        return email == null ? "" : email;
    }

    @Override
    @Basic
    @Column(name = "password", nullable = false)
    public String getPassword() {
        return password;
    }

    @Override
    @Basic
    @Column(name = "tel_phone")
    public String getTelPhone() {
        return telPhone == null ? "" : telPhone;
    }

    @Override
    @Basic
    @Column(name = "username")
    public String getUsername() {
        return username == null ? "" : username;
    }

    @Override
    @Basic
    @Column(name = "salt")
    public String getSalt() {
        return salt;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "pwd_last_update_time")
    public Date getPwdLastUpdateTime() {
        return pwdLastUpdateTime;
    }

    @Override
    @Basic
    @Column(name = "double_auth_flag")
    public Boolean getDoubleAuthFlag() {
        return doubleAuthFlag;
    }

    @Override
    @Basic
    @Column(name = "change_password_flag")
    public Boolean getChangePasswordFlag() {
        return changePasswordFlag;
    }

    @Override
    @Basic
    @Column(name = "bind_auth_flag")
    public Boolean getBindAuthFlag() {
        return bindAuthFlag;
    }

    @Override
    @Basic
    @Column(name = "passwd_length")
    public Integer getPasswdLength() {
        return passwdLength;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_login_time")
    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    @Transient
    public Long getTenantId() {
        return tenantId;
    }

    @Transient
    public String getRawPassword() {
        return rawPassword;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "account")
    public List<User> getUsers() {
        return users;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Account.class.getSimpleName() + "[", "]")
                .add("accountId=" + accountId)
                .add("email='" + email + "'")
                .add("telPhone='" + telPhone + "'")
                .add("status=" + status)
                .add("username='" + username + "'")
                .toString();
    }
}
