package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforceplus.domain.client.ClientDto;
import com.xforceplus.jpa.converter.GrantTypeConverter;
import com.xforceplus.jpa.listener.ClientListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.geewit.oltu.oauth2.common.message.types.GrantType;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author geewit
 */
@DynamicInsert
@DynamicUpdate
@EntityListeners({ClientListener.class})
@Entity
@Table(name = "bss_client")
public class Client extends ClientDto implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id")
    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name = "client_id")
    public String getClientId() {
        return clientId;
    }

    @Override
    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    @Override
    @Column(name = "secret")
    public String getSecret() {
        return secret;
    }

    @Override
    @Column(name = "client_name")
    public String getClientName() {
        return clientName;
    }

    @Override
    @Column(name = "client_app_id")
    public Integer getAppId() {
        return appId;
    }

    @Override
    @Column(name = "scope")
    public String getScope() {
        return scope;
    }

    @Override
    @Convert(converter = GrantTypeConverter.class)
    @Column(name = "grant_type")
    public GrantType getGrantType() {
        return grantType;
    }

    @Override
    @Column(name = "redirect_uri")
    public String getRedirectUri() {
        return redirectUri;
    }

    @Override
    @Column(name = "extension")
    public String getExtension() {
        return extension;
    }

    @Override
    @Column(name = "status")
    public Boolean getStatus() {
        return status;
    }

    @Override
    @Column(name = "resource_check")
    public Boolean getResourceCheck() {
        return resourceCheck;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Transient
    public List<Long> getTenantIds() {
        return tenantIds;
    }

    @Override
    public String toString() {
        return "Client{" +
                "clientId='" + clientId + '\'' +
                ", secret='" + secret + '\'' +
                ", clientName='" + clientName + '\'' +
                ", appId=" + appId +
                ", scope='" + scope + '\'' +
                ", grantType=" + grantType +
                ", redirectUri='" + redirectUri + '\'' +
                ", extension='" + extension + '\'' +
                ", status=" + status +
                ", resourceCheck=" + resourceCheck +
                ", createTime=" + createTime +
                '}';
    }
}
