package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.CompanyServiceRelListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.*;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;


/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyServiceRelListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode("company"),
                        @NamedAttributeNode("tenant"),
                        @NamedAttributeNode("servicePackage")
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_COMPANY,
                attributeNodes = {
                        @NamedAttributeNode("company")
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_TENANT,
                attributeNodes = {
                        @NamedAttributeNode("tenant")
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_SERVICE_PACKAGE,
                attributeNodes = {
                        @NamedAttributeNode("servicePackage")
                }
        )
})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_company_service_rel")
public class CompanyServiceRel implements Serializable {

    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "CompanyServiceRel.graph";
    public static final String NAMED_ENTITY_GRAPH_COMPANY = "CompanyServiceRel.graph.company";
    public static final String NAMED_ENTITY_GRAPH_TENANT = "CompanyServiceRel.graph.tenant";
    public static final String NAMED_ENTITY_GRAPH_SERVICE_PACKAGE = "CompanyServiceRel.graph.service-package";

    private Long id;

    private Long tenantId;

    private Long companyId;

    private Long servicePackageId;

    private String remarks;

    private Integer status;

    private String operateReason;

    private String createId;

    private Date createTime;

    private String createUserName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonIgnore
    private Tenant tenant;

    @JsonIgnore
    private Company company;

    @JsonIgnore
    private ServicePackage servicePackage;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @Basic
    @Column(name = "company_id", nullable = false)
    public Long getCompanyId() {
        return (companyId != null && companyId > 0) ? companyId : null;
    }

    @Basic
    @Column(name = "service_package_id", nullable = false)
    public Long getServicePackageId() {
        return (servicePackageId != null && servicePackageId > 0) ? servicePackageId : null;
    }

    @Basic
    @Column(name = "remarks", nullable = false)
    public String getRemarks() {
        return remarks;
    }

    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Company getCompany() {
        return company;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }


    @Basic
    @Column(name = "create_user_id")
    public String getCreateId() {
        return createId;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyServiceRel that = (CompanyServiceRel) o;
        return Objects.equals(tenantId, that.tenantId) &&
                Objects.equals(companyId, that.companyId) &&
                Objects.equals(servicePackageId, that.servicePackageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, companyId, servicePackageId);
    }
}
