package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.orgVirtual.OrgVirtualOrgStructDTO;
import com.xforceplus.jpa.listener.OrgVirtualOrgStructListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 10:52
*/
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_virtual_org_struct_rel")
@EntityListeners({OrgVirtualOrgStructListener.class})
public class OrgVirtualOrgStructRel extends OrgVirtualOrgStructDTO implements Serializable {

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Column(name = "org_virtual_id")
    public Long getOrgVirtualId() {
        return orgVirtualId;
    }

    @Override
    @Column(name = "org_struct_id")
    public Long getOrgStructId() {
        return orgStructId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }


    @Override
    @Basic
    @Column(name = "org_struct_name")
    public String getOrgStructName() {
        return orgStructName;
    }


    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }
}
