package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.conf.PrivacyAgreementDto;
import com.xforceplus.jpa.listener.PrivacyAgreementListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 隐私协议实体类
 *
 * @author HWT
 * @since 2022/1/06 15:50
 */
@NamedEntityGraphs({
        @NamedEntityGraph(name = PrivacyAgreement.NAMED_ENTITY_GRAPH_DEFAULT, attributeNodes = {
                @NamedAttributeNode("protocols")
        })
})
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({PrivacyAgreementListener.class})
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_privacy_agreement")
public class PrivacyAgreement extends PrivacyAgreementDto<PrivacyAgreementProtocol> implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "PrivacyAgreement.graph";

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @JsonView(View.class)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "content", nullable = false)
    @JsonView(View.class)
    public String getContent() {
        return content;
    }

    @Override
    @Basic
    @Column(name = "version")
    @JsonView(View.class)
    public String getVersion() {
        return version;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    @JsonView(View.class)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "company_type", nullable = false)
    @JsonView(View.class)
    public Integer getCompanyType() {
        return companyType;
    }


    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @JsonManagedReference
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "privacyAgreement")
    public List<PrivacyAgreementProtocol> getProtocols() {
        return super.protocols;
    }

    @JsonIgnore
    @Transient
    public void sortProtocols() {
        PrivacyAgreementDto.sortProtocols(super.protocols);
    }

    @JsonIgnore
    @Transient
    public void arrangeProtocolsOrdinal() {
        PrivacyAgreementDto.arrangeProtocolsOrdinal(super.protocols);
    }
}
