package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.*;
import com.xforceplus.domain.conf.PrivacyAgreementProtocolDto;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * @author geewit
 * @since 2022-01-12
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_privacy_agreement_protocol")
public class PrivacyAgreementProtocol extends PrivacyAgreementProtocolDto implements Serializable {
    @JsonView(View.class)
    @JsonBackReference
    private PrivacyAgreement privacyAgreement;

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @JsonView(View.class)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "agreement_id", nullable = false)
    @JsonView(View.class)
    public Long getAgreementId() {
        return agreementId;
    }

    @Override
    @Basic
    @Column(name = "title", nullable = false)
    @JsonView(View.class)
    public String getTitle() {
        return title;
    }

    @Override
    @Basic
    @Column(name = "url")
    @JsonView(View.class)
    public String getUrl() {
        return url;
    }

    @Override
    @Basic
    @Column(name = "ordinal", nullable = false)
    @JsonView(View.class)
    public Integer getOrdinal() {
        return ordinal;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "agreement_id", referencedColumnName = "id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public PrivacyAgreement getPrivacyAgreement() {
        return privacyAgreement;
    }
}
