package com.xforceplus.event.model;

import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.history.RevisionMetadata;

/**
 * 持久化实体保存前事件对象
 * @param <T>
 * @author geewit
 */
@Setter
@Getter
public class EntityPreSaveEvent<T> extends ApplicationEvent {
    private RevisionMetadata.RevisionType revisionType;

    public EntityPreSaveEvent(RevisionMetadata.RevisionType revisionType, T entity) {
        super(entity);
        this.revisionType = revisionType;
    }
}
