package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Client;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class ClientListener {
    @PrePersist
    public void prePersist(Client entity) {
        Date now = Calendar.getInstance().getTime();
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(now);
        }
        if (StringUtils.isEmpty(entity.getSecret())) {
            entity.setSecret(UUID.randomUUID().toString());
        }
    }
}