package com.xforceplus.jpa.listener;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.ICreater;
import org.apache.commons.lang3.StringUtils;

/***
 * @author geewit
 */
@SuppressWarnings("all")
public abstract class CreaterListener<C extends ICreater> {
    protected void beforeInsert(C entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreaterName(StringUtils.EMPTY);
            }
        }
    }
}
