/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ImportFilePersistenceListener.java   2020-09-23 17-34-37
 * Author: Evan
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.ExcelFileStore;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Date;

/**
 * <p>
 * Title: ImportFile监控器
 * </p>
 * <p>
 * Description: ImportFile监控器
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-23 17-34-37
 * @since V1.0
 */
public class ExcelFileStorePersistenceListener extends OperatorListener<ExcelFileStore> {
    @PrePersist
    public void prePersist(ExcelFileStore entity) {

        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(ExcelFileStore.class);
            entity.setId(id);
        }

        //创建时间
        entity.setCreateDate(new Date());
        //更新时间
        entity.setUpdateTime(new Date());

        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(ExcelFileStore entity) {
        super.beforeUpdate(entity);
    }
}
