package com.xforceplus.jpa.listener;


import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.PrePersist;
import java.util.Calendar;
import java.util.Date;


/**
 * 角色人员关系自动保存/更新的JPA 监听器
 *
 * @author duanhy
 * @since 2020-03-28
 */
public class RoleUserRelListener implements ApplicationEventPublisherAware {

    private static final Logger logger = LoggerFactory.getLogger(RoleUserRelListener.class);

    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(RoleUserRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreateName(authorizedUser.getOperaterName());
            } else {
                entity.setCreateName(StringUtils.EMPTY);
            }
            Date now = Calendar.getInstance().getTime();
            entity.setCreateTime(now);
        }
        this.trail(RevisionMetadata.RevisionType.INSERT, entity);
    }


    public void trail(RevisionMetadata.RevisionType type, RoleUserRel entity) {
        EntityPostSaveEvent<RoleUserRel> entityTrailEvent = new EntityPostSaveEvent<>(type, entity);
        try {
            applicationEventPublisher.publishEvent(entityTrailEvent);
        } catch (Exception e) {
            logger.error("tail publisher error", e);
        }
    }
}