package com.xforceplus.jpa.listener;


import com.xforceplus.entity.TenantRelation;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 租户自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class TenantRelationListener extends OperatorListener<TenantRelation> {
    @PrePersist
    public void prePersist(TenantRelation entity) {
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(TenantRelation.class);
            entity.setId(id);
        }

        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(TenantRelation entity) {
        super.beforeUpdate(entity);
    }
}