/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.PasswordHistory;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class AccountListener
extends OperatorListener<Account>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private final ThreadLocal<Boolean> passwordChangedThreadLocal = new ThreadLocal();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Account entity) {
        EntityPreSaveEvent<Account> entityPreSaveEvent = new EntityPreSaveEvent<Account>(RevisionMetadata.RevisionType.INSERT, entity);
        this.applicationEventPublisher.publishEvent(entityPreSaveEvent);
        if (entity.getAccountId() == null) {
            long id = SnowflakeGenerator.id(Account.class);
            entity.setAccountId(id);
        }
        if (StringUtils.isBlank((CharSequence)entity.getUsername())) {
            entity.setUsername("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTelPhone())) {
            entity.setTelPhone("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getEmail())) {
            entity.setEmail("");
        }
        if (entity.getBindAuthFlag() == null) {
            entity.setBindAuthFlag(false);
        }
        if (entity.getChangePasswordFlag() == null) {
            entity.setChangePasswordFlag(false);
        }
        if (entity.getDoubleAuthFlag() == null) {
            entity.setDoubleAuthFlag(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        this.cleanRelatedEntities(entity);
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Account entity) {
        if (entity instanceof ManagedEntity) {
            boolean passwordChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                passwordChanged = !Objects.equals(entityEntry.getLoadedValue("password"), entity.getPassword());
            } else {
                boolean bl = passwordChanged = entity.getPassword() != null;
            }
            if (passwordChanged) {
                entity.setChangePasswordFlag(false);
                entity.setPwdLastUpdateTime(Calendar.getInstance().getTime());
                EntityPreSaveEvent<Account> entityValidationEvent = new EntityPreSaveEvent<Account>(RevisionMetadata.RevisionType.UPDATE, entity);
                this.applicationEventPublisher.publishEvent(entityValidationEvent);
            }
            this.passwordChangedThreadLocal.set(passwordChanged);
        }
        if (StringUtils.isBlank((CharSequence)entity.getUsername())) {
            entity.setUsername("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTelPhone())) {
            entity.setTelPhone("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getEmail())) {
            entity.setEmail("");
        }
        this.cleanRelatedEntities(entity);
        super.beforeUpdate(entity);
    }

    @PostPersist
    public void postPersist(Account entity) {
        this.postSave(RevisionMetadata.RevisionType.INSERT, entity);
    }

    @PostUpdate
    public void postUpdate(Account entity) {
        this.postSave(RevisionMetadata.RevisionType.UPDATE, entity);
    }

    private void postSave(RevisionMetadata.RevisionType revisionType, Account entity) {
        boolean passwordChanged = (Boolean)ObjectUtils.defaultIfNull((Object)this.passwordChangedThreadLocal.get(), (Object)true);
        if (passwordChanged) {
            PasswordHistory passwordHistory = new PasswordHistory();
            passwordHistory.setTenantId(entity.getTenantId());
            passwordHistory.setAccountId(entity.getAccountId());
            passwordHistory.setPassword(entity.getPassword());
            EntityPostSaveEvent<PasswordHistory> entityPostSaveEvent = new EntityPostSaveEvent<PasswordHistory>(revisionType, passwordHistory);
            this.applicationEventPublisher.publishEvent(entityPostSaveEvent);
        }
        this.passwordChangedThreadLocal.remove();
    }

    private void cleanRelatedEntities(Account entity) {
        entity.setUsers(null);
    }
}

