/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Company;
import com.xforceplus.event.dto.CompanyNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import com.xforceplus.jpa.listener.OrgListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.geewit.utils.uuid.UUID;
import java.util.Objects;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class CompanyListener
extends OperatorListener<Company>
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(OrgListener.class);
    private ApplicationEventPublisher applicationEventPublisher;
    private final ThreadLocal<CompanyNameChanged> companyNameChangedThreadLocal = new ThreadLocal();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Company entity) {
        if (entity.getCompanyId() == null) {
            long id = SnowflakeGenerator.id(Company.class);
            entity.setCompanyId(id);
        }
        if (StringUtils.isEmpty((CharSequence)entity.getCompanyCode())) {
            String companyCode = UUID.randomUUID().toString();
            entity.setCompanyCode(companyCode);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank((CharSequence)entity.getTaxNum())) {
            throw new IllegalArgumentException("\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getCompanyName())) {
            throw new IllegalArgumentException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        this.cleanRelatedEntities(entity);
        super.beforeInsert(entity);
        this.trail(RevisionMetadata.RevisionType.INSERT, entity);
    }

    @PreUpdate
    public void preUpdate(Company entity) {
        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        boolean newCompanyName = false;
        String preCompanyName = null;
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                preCompanyName = (String)entityEntry.getLoadedValue("companyName");
                newCompanyName = !Objects.equals(preCompanyName, entity.getCompanyName());
            } else {
                boolean bl = newCompanyName = entity.getCompanyName() != null;
            }
        }
        if (newCompanyName) {
            CompanyNameChanged companyNameChanged = CompanyNameChanged.builder().companyId(entity.getCompanyId()).preCompanyName(preCompanyName).postCompanyName(entity.getCompanyName()).build();
            this.companyNameChangedThreadLocal.set(companyNameChanged);
        }
        this.cleanRelatedEntities(entity);
        super.beforeUpdate(entity);
    }

    @PostUpdate
    public void postUpdate(Company entity) {
        CompanyNameChanged companyNameChanged = this.companyNameChangedThreadLocal.get();
        if (companyNameChanged != null) {
            EntityPostSaveEvent<CompanyNameChanged> entityUpdateEvent = new EntityPostSaveEvent<CompanyNameChanged>(RevisionMetadata.RevisionType.UPDATE, companyNameChanged);
            this.applicationEventPublisher.publishEvent(entityUpdateEvent);
        }
        this.trail(RevisionMetadata.RevisionType.UPDATE, entity);
        this.companyNameChangedThreadLocal.remove();
    }

    private void cleanRelatedEntities(Company entity) {
        entity.setTenantRels(null);
        entity.setHostOrgs(null);
        entity.setHostTenant(null);
        entity.setOrgs(null);
    }

    @PostLoad
    public void postLoad(Company entity) {
        entity.postLoad();
    }

    public void trail(RevisionMetadata.RevisionType type, Company entity) {
        EntityPostSaveEvent<Company> entityTrailEvent = new EntityPostSaveEvent<Company>(type, entity);
        try {
            this.applicationEventPublisher.publishEvent(entityTrailEvent);
        }
        catch (Exception e) {
            logger.error("tail publisher error", (Throwable)e);
        }
    }
}

