/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

public class CompanyServiceRelListener {
    @PrePersist
    public void prePersist(CompanyServiceRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateId(String.valueOf(authorizedUser.getId()));
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreateUserName(authorizedUser.getOperaterName());
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreateUserName("");
                entity.setUpdaterName("");
            }
            Date now = Calendar.getInstance().getTime();
            entity.setCreateTime(now);
            entity.setUpdateTime(now);
        }
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyServiceRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdaterName("");
            }
        }
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(CompanyServiceRel entity) {
        entity.setServicePackage(null);
        entity.setCompany(null);
        entity.setTenant(null);
    }
}

